using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using nsAlienRFIDcf;



namespace nsAlienMobileSDK
{
    public partial class Form5 : Form
    {
        
        bool mbDisposing = false;
        clsReaderMonitor mMonitor = new clsReaderMonitor(true);

        private delegate void showMsg();

        public Form5()
        {
            InitializeComponent();
        }

        private void Form_Load(object sender, EventArgs e)
        {
            mMonitor.ReaderAdded += new clsReaderMonitor.ReaderAddedEventHandler(mMonitor_ReaderAdded);
            mMonitor.ReaderListUpdated += new clsReaderMonitor.ReaderListUpdatedEventHandler(mMonitor_ReaderListUpdated);
            mMonitor.ReaderRemoved += new clsReaderMonitor.ReaderRemovedEventHandler(mMonitor_ReaderRemoved);
            mMonitor.ReaderRenewed += new clsReaderMonitor.ReaderRenewedEventHandler(mMonitor_ReaderRenewed);

            lsvEvents.Columns.Add(new ColumnHeader());
            ColumnHeader header = new ColumnHeader();
            header.Text = "Discovered Readers";
            lsvReaders.Columns.Add(header);

            setInterval();
            mMonitor.StartListening();
        }

        void mMonitor_ReaderRenewed(IReaderInfo data)
        {
            AlienLog.WriteLine(true, data.ToString());
            showEvent(data.Name + "(" + data.MACAddress + ") is alive", Color.Blue); 
        }

        void mMonitor_ReaderRemoved(IReaderInfo data)
        {
            AlienLog.WriteLine(true, data.ToString());
            showEvent(data.Name + "(" + data.MACAddress + ") LOST", Color.Red);
        }

        void mMonitor_ReaderListUpdated()
        {
            //AlienLog.WriteLine(true, "ReaderListUpdated event.");
            //showEvent("ReaderList updated.", Color.Yellow);
        }

        void mMonitor_ReaderAdded(IReaderInfo data)
        {
            AlienLog.WriteLine(true, data.ToString());
            showEvent(data.Name + "(" + data.MACAddress + ") added", Color.Lime);
        }

        void showEvent(string text, Color color)
        {
            if ((mbDisposing) || (text == null)) return;

            lock (this)
            {
                showMsg method = delegate
                {
                    addText(text, color);
                };
                this.BeginInvoke(method);
            }
        }

        void addText(string text, Color color)
        {
            ListViewItem item = new ListViewItem(text);
            item.ForeColor = color;
            lsvEvents.Items.Add(item);
            lsvEvents.Refresh();
        }


        private void Form_Closing(object sender, CancelEventArgs e)
        {
            mbDisposing = true;

        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            mMonitor.ClearAllReaders();
            //lock (moReaderLock) { mdReaders.Clear(); }
            lsvReaders.Items.Clear();
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            //btnClear_Click(null, null);
            IReaderInfo[] rs;
            string response = mMonitor.GetReaderList(out rs);
            if (!string.IsNullOrEmpty(response))
                addText(response, Color.White);
            else
            {
                for (int i = 0; i < rs.Length; i++)
                    addReader(rs[i]);
            }
            setInterval();
        }

        void addReader(IReaderInfo readerInfo)
        {
            string mac = readerInfo.MACAddress;
            bool found = false;
            foreach (ListViewItem item in lsvReaders.Items)
            {
                if (mac == (item.Tag as IReaderInfo).MACAddress)
                    found = true;
            }
            if (!found)
            {
                string name = readerInfo.Name;
                ListViewItem item = new ListViewItem(name);
                item.Tag = readerInfo;
                lsvReaders.Items.Add(item);
            }
        }

        private void lsvReaders_SelectedIndexChanged(object sender, EventArgs e)
        {
            ListView.SelectedIndexCollection indeces = lsvReaders.SelectedIndices;
            if (indeces.Count > 0)
            {
                ReaderInfo readerInfo = 
                    lsvReaders.Items[indeces[0]].Tag as ReaderInfo;

                if (readerInfo != null)
                {
                    Reader_Details readerDetails = new Reader_Details(readerInfo);
                    readerDetails.ShowDialog();
                }
            }
        }

        private void chkListen_CheckStateChanged(object sender, EventArgs e)
        {
            if (chkListen.Checked)
                mMonitor.StartListening();
            else
                mMonitor.StopListening();
        }

        private void txtUpdateTime_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
                setInterval();
        }

        private void setInterval()
        {
            int interval = 0;
            try { interval = int.Parse(txtUpdateTime.Text); }
            catch { }
            if (interval > 0)
                mMonitor.UpdateInterval = interval * 1000;
        }

    }
}